<% '******************************************
'
' ******  COM Objects Initialize *************
'
'******************************************

'********************************************************************************
'If you should have any comments, suggestions or improvements to these samples,
'we welcome you to contact us at SampleCode@melissadata.com also please visit our
'developers bulletin board at forum.melissadata.com.
'********************************************************************************

' ********************** LICENSE STRINGS ***********************
'       To unlock the full functionality of Address Object,    
'   please call a sales representative at 1-800-MELISSA ext. 3 
'           (1-800-635-4772 x3) for a license string.          
'        Without a valid license string, AddressCheck will     
'                  only verify Nevada addresses.               
'   SetLicenseString will also check for a valid license in the 
'  MDADDR_LICENSE(Environment) variable. This allows you to  
'   modify the license without recompiling the project
' **************************************************************
Const dLICENSE = "DEMO"

' ********************** DATA FILE PATH  ***********************
'  File location path is set to the default Data File location. 
'  Change this value if you installed the data files to a       
'  different folder.                                            
'  The Data Files Directory must contain the following files:   
'  mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str
' **************************************************************
Const dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data"

'Create the objects.
set addrObj= server.CreateObject("AddressObject.AddressCheck")
set streetObj= server.CreateObject("AddressObject.StreetData")
set parseObj= server.CreateObject("AddressObject.Parse")
set zipObj= server.CreateObject("AddressObject.ZipCodeData")
dim cBuff 'Buffer to hold output comment data


'Call these subs when necessary to initialize objects
sub addrObjInit
  addrObj.SetLicenseString(dLICENSE)
  addrObj.PathToUSFiles = dFILELOC
  'addrObj.PathToDPVDataFiles = dFILELOC           'DPV Add-on
  'addrObj.PathToLACSLinkDataFiles = dFILELOC      'LACS Link Add-on
  'addrObj.PathToSuiteLinkDataFiles = dFILELOC     'SuiteLink Add-on

        'addrObj.PathToRBDIFiles = dFILELOC              'RBDI Add-on
  'addrObj.PathToCanadaFiles = dFILELOC            'Canadian Add-on
  'addrObj.PathToSuiteFinderDataFiles = dFILELOC   'SuiteFinder Add-on

  addrObj.InitializeDataFiles
end sub

sub streetObjInit
  streetObj.SetLicenseString(dLICENSE)
  if streetObj.Initialize(dFILELOC, dFILELOC,"") then x=0
end sub

sub zipObjInit
  zipObj.SetLicenseString(dLICENSE)
  if zipObj.Initialize(dFILELOC ,dFILELOC )then x=0
end sub

sub parseObjInit
  parseObj.Initialize(dFILELOC)
end sub

'Call these subs when printing output to screen
sub printParseProperties
  dim lineEnd
  if Request.Form("bsubmit")="Reparse" then
    lineEnd=" "
  else
    lineEnd=vbCrLf
  end if

  cBuff=cBuff&"Rnge="&parseObj.Range&lineEnd
  cBuff=cBuff&"PreDir="&parseObj.PreDirection&lineEnd
  cBuff=cBuff&"StrtName="&parseObj.StreetName&lineEnd
  cBuff=cBuff&"Suf="&parseObj.Suffix&lineEnd
  cBuff=cBuff&"PostDir="&parseObj.PostDirection&lineEnd
  cBuff=cBuff&"SteName="&parseObj.SuiteName&lineEnd
  cBuff=cBuff&"SteNum="&parseObj.SuiteNumber&lineEnd
  'cBuff=cBuff&"PMName="&parseObj.PrivateMailboxName&lineEnd
  'cBuff=cBuff&"PMNum="&parseObj.PrivateMailboxNumber&lineEnd
  cBuff=cBuff&"Grbg="&parseObj.Garbage&vbCrLf


end sub

sub printStreetProperties
  'Filling and formating comment form with initial results.
  cBuff=cBuff&streetObj.PrimaryRangeLow&"-"
  cBuff=cBuff&streetObj.PrimaryRangeHigh&" "
  cBuff=cBuff&streetObj.PrimaryRangeOddEven&" "
  cBuff=cBuff&streetObj.PreDirection&" "
  cBuff=cBuff&streetObj.StreetName&" "
  cBuff=cBuff&streetObj.Suffix&" "
  cBuff=cBuff&streetObj.PostDirection&" "
  If not (streetObj.SuiteName="") then
    cBuff=cBuff&streetObj.SuiteName&" "
  else
    cBuff=cBuff&"     "
  end if
  If not (streetObj.SuiteRangeLow="") Then
    cBuff=cBuff&trim(streetObj.SuiteRangeLow)&"-"
  else
    cBuff=cBuff&"  "
  End if
  If not (streetObj.SuiteRangeHigh="") then
    cBuff=cBuff&trim(streetObj.SuiteRangeHigh)&" "
  else
    cBuff=cBuff&" "
  end if
  cBuff=cBuff&streetObj.SuiteRangeOddEven&" "
  cBuff=cBuff&streetObj.Zip&" "
  cBuff=cBuff&streetObj.Plus4Low&"-"
  cBuff=cBuff&streetObj.Plus4High&vbCrLf
end sub
sub printZipProperties
  cBuff=cBuff&zipObj.Zip&" "
  cBuff=cBuff&zipObj.City&" "
  cBuff=cBuff&zipObj.State&" "
  cBuff=cBuff&zipObj.AreaCode&" "
  cBuff=cBuff&zipObj.CountyFips&" "
  cBuff=cBuff&zipObj.CountyName&" "
  cBuff=cBuff&zipObj.Latitude&" "
  cBuff=cBuff&zipObj.Longitude&" "
  cBuff=cBuff&zipObj.LastLineIndicator&vbCrLf
end sub
%>
<HTML>
  <HEAD>
    <META http-equiv='Content-Language' content='en-us'>
    <META http-equiv='Content-Type' content='text/html charset=UTF-8'>
    <META http-equiv='ImageToolbar' content='no'>

    <META name='Author' content='Melissa Data Corporation'>
    <META name='Description' content='AddressObject: ASP Sample Code.'>

    <TITLE>AddressObject: ASP Sample Code</TITLE>



<%
  'Using ASP:
  'Setting page variables and clearing them.
  dim Build
  dim ExpDate
  dim DatabaseDate
  dim InitErrorString
  dim cCompany
  dim cAddress
  dim cAddress2
  dim cSuite
  dim cCity
  dim cState
  dim cZip
  dim cPlus4
  dim cLastName
  dim ResultsDesc
  dim ResultsString
  dim comments
  Build="----"
  ExpDate="----"
  DatabaseDate="----"
  InitErrorString="----"

  fCompany=Request.Form("Company")  'f-variables used to hold inital input info passed through pages.
  fAddress=Request.Form("Address")
  fAddress2 =Request.Form("Address2")
  fCity =Request.Form("City")
  fState =Request.Form("State")
  fZip =Request.Form("Zip")
  fPlus4 =Request.Form("Plus4")
  fLastName = Request.Form("LastName")

  'If Verify button is pressed, run Verify Address.
  if (Request.Form("bsubmit") ="Verify")then
    'Loading form with database date, expiration date, build, and initialization status.
    call addrObjInit
    Build=addrObj.GetBuildNumber
    DatabaseDate=addrObj.GetUSDatabaseDate
    ExpDate=addrObj.GetUSExpirationDate
    InitErrorString=addrObj.GetInitializeErrorString

    ' clear any remaining properties from a previous call
    addrObj.ClearProperties()
    
    'Loading values from Post into Object.
    addrObj.Company=Request.Form("Company")
    addrObj.Address=Request.Form("Address")
    addrObj.Address2=Request.Form("Address2")
    addrObj.City=Request.Form("City")
    addrObj.State = Request.Form("State")
    addrObj.Plus4 = Request.Form("Plus4")
    addrObj.ZIP = Request.Form("Zip")
    addrObj.LastName = Request.Form("LastName")


    'Verifying address.  Note: VerifyAddress() will return TRUE if successful.
    addrObj.VerifyAddress()

    'Loading form with captured and corrected data.
    cCompany=addrObj.Company
    cAddress=addrObj.Address
    cAddress2=addrObj.Address2
    cSuite=addrObj.Suite
    cCity=addrObj.City
    cState=addrObj.State
    cZip=addrObj.Zip
    cPlus4=addrObj.Plus4

    ' results are returned as a delimited string, so we parse here...
    ResultsString=addrObj.Results
    If ((InStr(1, ResultsString, "AS01")) Or (InStr(1, ResultsString, "AS02")) Or (InStr(1, ResultsString, "AS03"))) Then
      ' address was verified
      If (InStr(1, ResultsString, "AS01")) Then
            ResultsDesc=ResultsDesc&"AS01: Full Address Matched to Postal Database and is deliverable " + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS02")) Then
            ResultsDesc=ResultsDesc&"AS02: Address matched to USPS database but a suite was missing Or invalid" + vbCrLf
      End If
	   If (InStr(1, ResultsString, "AS03")) Then
			ResultsDesc=ResultsDesc&"AS03: Valid Physical Address, not Serviced by the USPS " + vbCrLf
	  End If
    End If
        
      '  Display additional level of verification/comments 
     
      If (InStr(1, ResultsString, "AS09")) Then
            ResultsDesc=ResultsDesc&"AS09: Foreign Postal Code Detected " + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS10")) Then
            ResultsDesc=ResultsDesc&"AS10: Address Matched to CMRA" + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS13")) Then
            ResultsDesc=ResultsDesc&"AS13: Address has been Updated by LACSLink " + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS14")) Then
            ResultsDesc=ResultsDesc&"AS14: Suite Appended by SuiteLink " + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS15")) Then
            ResultsDesc=ResultsDesc&"AS15: Suite Appended by SuiteFinder " + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS16")) Then
            ResultsDesc=ResultsDesc&"AS16: Address is vacant." + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS17")) Then
            ResultsDesc=ResultsDesc&"AS17: Alternate delivery." + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS18")) Then
            ResultsDesc=ResultsDesc&"AS18: Artificially created adresses detected,DPV processing terminated at this point.  + vbCrLf"
      End If
      If (InStr(1, ResultsString, "AS20")) Then
            ResultsDesc=ResultsDesc&"AS20: Address Deliverable by USPS only " + vbCrLf
      End If
      If (InStr(1, ResultsString, "AS21")) Then
            ResultsDesc=ResultsDesc&"AS21: Alternate Address Suggestion Found " + vbCrLf
      End If            
      If (InStr(1, ResultsString, "AS22")) Then
            ResultsDesc=ResultsDesc&"AS22: No Alternate Address Suggestion Found" + vbCrLf
      End If            
      If (InStr(1, ResultsString, "AS23")) Then
            ResultsDesc=ResultsDesc&"AS23: Extraneous information found" + vbCrLf
      End If              
             
            
    If (InStr(1, ResultsString, "AE")) Then
          ' there was an error in verifying the address
          If (InStr(1, ResultsString, "AE01")) Then
              ResultsDesc=ResultsDesc&"AE01: Zip Code Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE02")) Then
              ResultsDesc=ResultsDesc&"AE02: Unknown Street Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE03")) Then
              ResultsDesc=ResultsDesc&"AE03: Component Mismatch Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE04")) Then
              ResultsDesc=ResultsDesc&"AE04: Non-Deliverable Address Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE05")) Then
              ResultsDesc=ResultsDesc&"AE05: Multiple Match Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE06")) Then
              ResultsDesc=ResultsDesc&"AE06: Early Warning System Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE07")) Then
              ResultsDesc=ResultsDesc&"AE07: Missing Minimum Address Input " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE08")) Then
              ResultsDesc=ResultsDesc&"AE08: Suite Range Invalid Error" + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE09")) Then
              ResultsDesc=ResultsDesc&"AE09: Suite Range Missing Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE10")) Then
              ResultsDesc=ResultsDesc&"AE10: Primary Range Invalid Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE11")) Then
              ResultsDesc=ResultsDesc&"AE11: Primary Range Missing Error " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE12")) Then
              ResultsDesc=ResultsDesc&"AE12: PO, HC, or RR Box Number Invalid " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE13")) Then
              ResultsDesc=ResultsDesc&"AE13: PO, HC, or RR Box Number Missing " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE14")) Then
              ResultsDesc=ResultsDesc&"AE14: CMRA Secondary Missing Error" + vbCrLf
          End If

          ' program can not attempt address lookup
          If (InStr(1, ResultsString, "AE15")) Then
              ResultsDesc=ResultsDesc&"AE15: Demo Mode, valid license required " + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE16")) Then
              ResultsDesc=ResultsDesc&"AE16: Expired Database, Please update" + vbCrLf
          End If
          
          If (InStr(1, ResultsString, "AE17")) Then
              ResultsDesc=ResultsDesc&"AE17: Unnecessary Suite Error" + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE19")) Then
              ResultsDesc=ResultsDesc&"AE19: Max time for FindSuggestion exceeded" + vbCrLf
          End If
          If (InStr(1, ResultsString, "AE20")) Then
              ResultsDesc=ResultsDesc&"AE20: FindSuggestion cannot be used " + vbCrLf
          End If
    End If
     
    ' the input was changed    
    If (InStr(1, ResultsString, "AC01")) Then
        ResultsDesc=ResultsDesc&"AC01: ZIP Code Change " + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC02")) Then
        ResultsDesc=ResultsDesc&"AC02: State Change" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC03")) Then
        ResultsDesc=ResultsDesc&"AC03: City Change" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC04")) Then
        ResultsDesc=ResultsDesc&"AC04: Base/Alternate Change" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC05")) Then
        ResultsDesc=ResultsDesc&"AC05: Alias Name Change " + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC06")) Then
        ResultsDesc=ResultsDesc&"AC06: Address1/Address2 Swap" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC07")) Then
        ResultsDesc=ResultsDesc&"AC07: Address1/Company Swap" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC08")) Then
        ResultsDesc=ResultsDesc&"AC08: Plus4 Change" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC09")) Then
        ResultsDesc=ResultsDesc&"AC09: Urbanization Change" + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC10")) Then
        ResultsDesc=ResultsDesc&"AC10: Street Name Change " + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC11")) Then
        ResultsDesc=ResultsDesc&"AC11: Street Suffix Change " + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC12")) Then
        ResultsDesc=ResultsDesc&"AC12: Street Directional Change " + vbCrLf
    End If
    If (InStr(1, ResultsString, "AC13")) Then
        ResultsDesc=ResultsDesc&"AC13: Suite Name Change " + vbCrLf
    End If
    
    'Loading the comment text field with extra data and flags that are set when
    'the VerifyAddress Method is called. 
    
    comments="CarrierRoute="&addrObj.CarrierRoute & vbCrLf
    comments=comments&"DeliveryPointCheckDigit="&addrObj.DeliveryPointCheckDigit&vbCrLf
    comments=comments&"DeliveryPointCode="&addrObj.DeliveryPointCode&vbCrLf
    comments=comments&"DPVFootnotes="&addrObj.DPVFootnotes&vbCrLf
    comments=comments&vbCrLf
    comments=comments&"AddressTypeCode="&addrObj.AddressTypeCode&vbCrLf
    comments=comments&"AddressTypeString="&addrObj.AddressTypeString&vbCrLf
    comments=comments&"CityAbbreviation="&addrObj.CityAbbreviation&vbCrLf
    comments=comments&"CountyName="&addrObj.CountyName&vbCrLf   
    comments=comments&"CountyFips="&addrObj.CountyFips&vbCrLf
    comments=comments&"CountryCode="&addrObj.CountryCode&vbCrLf
    comments=comments&"CongressionalDistrict="&addrObj.CongressionalDistrict&vbCrLf
    comments=comments&"TimeZone="&addrObj.TimeZone&vbCrLf
    comments=comments&"TimeZoneCode="&addrObj.TimeZoneCode&vbCrLf
    comments=comments&"Urbanization="&addrObj.Urbanization&vbCrLf
    comments=comments&"ZipType="&addrObj.ZipType&vbCrLf   
    comments=comments&vbCrLf
    comments=comments&"ParsedAddressRange="&addrObj.ParsedAddressRange & vbCrLf
    comments=comments&"ParsedPreDirection="&addrObj.ParsedPreDirection& vbCrLf
    comments=comments&"ParsedStreetName="&addrObj.ParsedStreetName& vbCrLf
    comments=comments&"ParsedSuffix="&addrObj.ParsedSuffix& vbCrLf
    comments=comments&"ParsedPostDirection="&addrObj.ParsedPostDirection& vbCrLf
    comments=comments&"ParsedSuiteName="&addrObj.ParsedSuiteName& vbCrLf
    comments=comments&"ParsedSuiteRange="&addrObj.ParsedSuiteRange& vbCrLf
    comments=comments&"ParsedPrivateMailboxName="&addrObj.ParsedPrivateMailboxName& vbCrLf
    comments=comments&"ParsedPrivateMailboxNumber="&addrObj.ParsedPrivateMailboxNumber& vbCrLf
    comments=comments&"ParsedGarbage="&addrObj.ParsedGarbage&vbCrLf
    comments=comments&vbCrLf
    comments=comments&"MSA="&addrObj.MSA&vbCrLf
    comments=comments&"PMSA="&addrObj.PMSA&vbCrLf
    comments=comments&"CMRA="&addrObj.CMRA&vbCrLf
    comments=comments&"PrivateMailbox="&addrObj.PrivateMailbox&vbCrLf
    comments=comments&vbCrLf
    comments=comments&"ELotOrder="&addrObj.ELotOrder&vbCrLf
    comments=comments&"ELotNumber="&addrObj.ELotNumber&vbCrLf
    comments=comments&"LACS="&addrObj.LACS&vbCrLf
    comments=comments&"LACSLinkIndicator="&addrObj.LACSLinkIndicator&vbCrLf
    comments=comments&"LACSLinkReturnCode="&addrObj.LACSLinkReturnCode&vbCrLf
    comments=comments&"SuiteLinkReturnCode="&addrObj.SuiteLinkReturnCode&vbCrLf
    comments=comments&"EWS="&addrObj.EWSFlag&vbCrLf
    comments=comments&"RBDI="&addrObj.RBDI&vbCrLf


  ' If Parse button is pressed, run parse routine.
  elseif(Request.Form("bsubmit")="Parse") then

    'Get build info.
    call parseObjInit
    Build=parseObj.GetBuildNumber

    'Calling Parse(), the first parsing of the address text from
    'Must be run before ParseNext().
    parseObj.Parse(Request.Form("Address"))

    'Filling comment field with captured parsed data.
    cBuff="Parsing this string: "&Request.Form("Address")&vbCrLf
    call printParseProperties
    comments=cBuff

  ' If Reparse button is pressed, run reparse routine.
  ' Because PHP cannot pass com objects through pages, reparse loop is
  ' completed in one page.
  elseif(Request.Form("bsubmit")="Reparse") then


    call parseObjInit
    Build=parseObj.GetBuildNumber

    'Calling Parse(), the first parsing of the address text from Form
    'Must be run before ParseNext().
    parseObj.Parse(Request.Form("Address"))

    'Filling comment field with captured parsed data.
    cBuff="Parsing this string: "&Request.Form("Address")&vbCrLf
    call printParseProperties

    'Now looping ParseNext until it runs out of token combinations&
    while(parseObj.ParseNext())
      'Filling comment field with captured parsed data&
      call printParseProperties
    wend

    cBuff=cBuff&"Finished Re-parsing"
    comments=cBuff


  'If Parse Last Line is selected, run parse last routine.
  elseif(Request.Form("bsubmit")="Parse Last Line") then
    'Loading parseObj
    call parseObjInit
    Build=parseObj.GetBuildNumber

    'This implementation parses the COMBINED string taken from City,State,
    ' Zip and Plus4.  To test, feel free to enter entire CITY,STATE AND ZIP into City Field
    parseObj.LastLineParse(Request.Form("City")&" "&Request.Form("State")&" "&Request.Form("Zip")&" "&Request.Form("Plus4"))

    'Filling comment field with captured parsed data&
    comments="Parsing this string: '"&Request.Form("City")&" "&Request.Form("State")&" "&Request.Form("Zip")&" "&Request.Form("Plus4")&"'"
    comments=comments&vbCrLf&"City="&parseObj.City&vbCrLf
    comments=comments&"State="&parseObj.State&vbCrLf
    comments=comments&"Zip="&parseObj.Zip&vbCrLf
    comments=comments&"Plus4="&parseObj.Plus4&vbCrLf

  'If Find Street is selected, run find street routine.
  elseif(Request.Form("bsubmit")="Find Street") then
    call streetObjInit
    'Loading form with database date, expiration date, build, and initialization status.
    Build=streetObj.GetBuildNumber
    DatabaseDate=streetObj.GetDatabaseDate
    InitErrorString=streetObj.GetInitializeErrorString

    'Loading Parse Object to hold parsed full address.
    call parseObjInit
    'Parsing Address value once to obtain only the Street Name and storing result.
    parseObj.Parse(Request.Form("Address"))
    'Creating variable to hold only the parsed StreetName.
    pStreet=parseObj.StreetName

    'Calling and testing FindStreet() to find the first street range found with input data.
    'FindStreet() Returns FALSE is no street record is found.

    if ( streetObj.FindStreet(pStreet,Request.Form("Zip"),"0")=0) then
      'FindStreet() did not find the specified street in the zip code, show warning.
      'Check if your street in address is spelled correctly.  If you have reparsed manually, it may
      'have scrambled the input address so it would not be recognized by FindStreet().

      Response.Write("<script language=VBScript>")
      Response.Write("MsgBox(""Unable to locate specific Street Name in Zip Code."")</script>")
    else
      'Sucessful, recognized street and zip.
      'Clear buff and print properties
      cBuff=""
      call printStreetProperties

      'Now will loop to try to find the next data&  Loop exits when FALSE&
      'FindStreetNext() returns TRUE if next record exists
      while(streetObj.FindStreetNext())
        'Filling comment form with next result&
        call printStreetProperties
      wend
      comments=cBuff
    end if

  'Option to find Cities in States with values from form
  'Wild card * values can be used for City value.
  elseif(Request.Form("bsubmit")="City in State") then
    'Steps to Initialize zipObj
    call zipObjInit
    'Loading form with database date, expiration date, build, and initialization status.
    Build=zipObj.GetBuildNumber
    DatabaseDate=zipObj.GetDatabaseDate
    InitErrorString=zipObj.GetInitializeErrorString

    'Call and test FindCityInState() to find first city in specified state.
    'FindCityInState() returns true if record is found.
    if(zipObj.FindCityInState(Request.Form("City"),Request.Form("State"))) then
      'Successful.  Filling comment form with initial results.
      comments =zipObj.City&" "
      comments=comments&zipObj.State&vbCrLf

      'Now will loop to try to find the next data.  Loop exits when FALSE.
      'FindCityinStateNext() returns TRUE if next record exists.
      while(zipObj.FindCityInStateNext())
        'Filling comment form with next result.
        comments=comments&zipObj.City&" "
        comments=comments&zipObj.State&vbCrLf
      wend
    else
      'Not successful, display warning.
      Response.Write("<script language=VBScript>")
      Response.Write("MsgBox(""Could Not Find City in State."")</script>")
    end if

  'If Zip in City button is selected, run zip in city routine.
  elseif(Request.Form("bsubmit")="Zip in City") then
    'Steps to Initialize zipObj
    'Loading zipObj

    call zipObjInit

    'Loading form with database date, expiration date, build, and initialization status.
    Build=zipObj.GetBuildNumber
    DatabaseDate=zipObj.GetDatabaseDate
    InitErrorString=zipObj.GetInitializeErrorString

    'Call and test ZipInCity() to find first zip code in specified city and state.
    'ZipInCity() returns true if record is found.
    if(zipObj.FindZipInCity(Request.Form("City"),Request.Form("State"))) then
      'Successful.  Filling comment form with initial results.
      cBuff =""
      call printZipProperties
      'Now will loop to try to find the next data&  Loop exits when FALSE&
      'FindZipInCityNext() returns TRUE if next record exists&
      while(zipObj.FindZipInCityNext())
        'Filling comment form with next result&
        call printZipProperties
      wend
      comments=cBuff
    else
      'Not successful, display warning.
      Response.Write("<script language=VBScript>")
      Response.Write("MsgBox(""Could Not Find Zip Code in City."")</script>")
    end if

  'Option to find the Cities/States associated with a specified zip.
  elseif(Request.Form("bsubmit")="Find Zip") then

    'Steps to Initialize zipObj
    'Loading zipObj

    call zipObjInit
    'Loading form with database date, expiration date, build, and initialization status.
    Build=zipObj.GetBuildNumber
    DatabaseDate=zipObj.GetDatabaseDate
    InitErrorString=zipObj.GetInitializeErrorString

    'Call and test FindZip() to find first zip code in specified city and state.
    'FindZip() returns true if record is found.
    if(zipObj.FindZip(Request.Form("Zip"),0)) then
      'Successful.  Creating header for output.
      'Filling comment form with initial results.
      cBuff =""
      call printZipProperties
      'Now will loop to try to find the next data&  Loop exits when FALSE&
      'FindZipNext() returns TRUE if next record exists&
      while(zipObj.FindZipNext())
        'Filling comment form with next result&
        'Filling comment form with next result&
        call printZipProperties
      wend
      comments=cBuff
    else
      'Not successful, display warning.
      Response.Write("<script language=VBScript>")
      Response.Write("MsgBox(""Could Not Find Zip Code."")</script>")
    end if

  'All other options failed, meaning the page is initially loaded, so loading
  'input fields with default information.
  else
    fCompany="ABC Company"
    fAddress="201 10th St."
    fAddress2=""
    fCity="Las Vegas"
    fState="NV"
    fZip="89101"
    fPlus4=""
  end if
%>
  </HEAD>

<body>

    <TABLE border='0' cellpadding='0' cellspacing='0' width='744'>
      <TR>
        <TD background='background.gif' height='59'>
          <a href='http:'www.melissadata.com'><img border='0' src='melissadata.gif' width='218' height='21'>
        </TD>
      </TR>
      <TR style='font-family:arial;font-size:110%;color:white'>
        <TD align='center' background='background.gif' colspan='4' height='30'><B>AddressObject: ASP Sample Code</B></TD>
      </TR>
    </TABLE>

    <FORM method='post' action="">
      <TABLE width='744' style='font-family:arial;font-size:80%'>
        <TR><TD></TD></TR>
        <TR><TD Colspan='2'><B>Database Status:</b></TD></TR>
        <TR>
          <TD Colspan='2'style='font-family:arial;font-size:7.8pt;color:gray'>
            Build: <INPUT type='text' name='Build' size='13' value='<%Response.Write(  Build) %>' disabled>
            Database Date: <INPUT type='text' name='DatabaseDate' size='7' value='<%Response.Write(  DatabaseDate) %>' disabled>
            Exp. Date: <INPUT type='text' name='ExpDate' size='7' value='<%Response.Write(  ExpDate) %>' disabled>
          </td>
        </TR>
        <TR>
          <Td colspan='2' style='font-family:arial;font-size:7.8pt;color:gray'>
            <align='right'>Init. Error String: <INPUT type='text' name='initErrorString' size='50' value='<%Response.Write(  InitErrorString) %>' disabled></TD>
          </td>
        </tr>
        <TR>
          <TD colspan='1'><B>Input:</B></TD>
          <TD colspan='1'><B>Output Address Verifcation:</B></TD>
        </TR>
        <TR>
          <td>
            <TABLE width='350'  style='font-family:arial;font-size:7.8pt'>
              <TR>
                <TD align='right'><b>Company:</b></TD>
                <TD><INPUT type='text' name='Company' size='35' value='<%Response.Write(  fCompany) %>'></TD>
              </TR>
              <TR>
                <TD align='right'><b>Address:</b></TD>
                <TD><INPUT type='text' name='Address' size='35' value='<%Response.Write(  fAddress) %>'></TD>
              </TR>
              <TR>
                <TD align='right'></TD>
                <TD><INPUT type='text' name='Address2' size='35' value='<%Response.Write(  fAddress2) %>'></TD>
              </tr>
              <tr>
                <TD align='right'><b>City:</b></TD>
                <TD><INPUT type='text' name='City' size='21' value='<%Response.Write(  fCity) %>'>  <b>State:</b> <INPUT type='text' name='State' size='2' value='<%Response.Write(  fState) %>'></TD>
              </tr>
              <tr>
                <TD align='right'><b>Zip:</b></TD>
                <TD><INPUT type='text' name='Zip' size='2' value='<%Response.Write(  fZip) %>'>  <b> - </b> <INPUT type='text' name='Plus4' size='1' value='<%Response.Write(  fPlus4) %>'>
                <b>Last Name:</b>
                <INPUT type='text' name='LastName' size='11' value='<%Response.Write(  fLastName) %>'>  <b></td>

              </tr>
              <tr>
                <TD align='right'>Address</td>
                <TD><INPUT type='submit' name='bsubmit' value='Verify'></td>
              </tr>
              <tr>
                <TD align='right'>Parse</td>
                <TD><INPUT type='submit' name='bsubmit'value='Parse' onclick=''><INPUT type='submit' name='bsubmit' value='Reparse'><INPUT type='submit' name='bsubmit' value='Parse Last Line'></td>
              </tr>

              <tr>
                <TD align='right'>Street</td>
                <TD><INPUT type='submit' name='bsubmit' value='Find Street'></td>
              </tr>
              <tr>
                <TD align='right'>Zip</td>
                <TD><INPUT type='submit' name='bsubmit' value='City in State'><INPUT type='submit' name='bsubmit' value='Zip in City'><INPUT type='submit' name='bsubmit' value='Find Zip'></td>
              </tr>
            </TD></TR></TABLE>
          </td>
          <td valign='top'>
            <TABLE width='350' style='font-family:arial;font-size:7.8pt;color:gray'>
            <TR>
              <TD align='right'>Company:</TD>
              <TD  colspan='2'><INPUT type='text' name='cCompany' size='24' value='<%Response.Write(  cCompany) %>' disabled></TD>
            </TR>
            <TR>
              <TD align='right'>Address:</TD>
              <TD><INPUT type='text' name='cAddress' size='24' value='<%Response.Write(  cAddress) %>' disabled></TD>
            </TR>
            <TR>
              <TD align='right'>Address2:</TD>
              <TD><INPUT type='text' name='cAddress2' size='24' value='<%Response.Write(  cAddress2) %>' disabled></TD>
              <TD></tD>
            <TR>
              <TD align='right'>Suite:</TD>
              <TD><INPUT type='text' name='cSuite' size='24' value='<%Response.Write(  cSuite) %>' disabled></TD>
            </TR>
            <tr>
              <TD align='right'>City:</TD>
              <TD><INPUT type='text' name='cCity' size='24' value='<%Response.Write(  cCity) %>' disabled></TD>
            </tr>
            <tr>
              <TD align='right'>State:</TD>
              <TD colspan='2'><INPUT type='text' name='cState' size='1' value='<%Response.Write(  cState) %>' disabled> Zip: <INPUT type='text' name='cZip' size='2' value='<%Response.Write(  cZip) %>' disabled> - <INPUT type='text' name='cPlus4' size='1' value='<%Response.Write(  cPlus4) %>' disabled></td>
            </tr>
            <tr>
              <td align='right'>Results:</td>
              <TD><textarea rows="7" cols="52" name='ResultsDesc' size='50' style='font-family:arial;font-size:10pt;color:blue'><%Response.Write(  ResultsDesc) %></textarea></TD>
            </tr>
            </table>
          </td>
        </tr>
        <tr>
          <TD colspan='1'><B>Other Data:</B></td>
          <TD colspan='1'><B></B></TD>
        </tr>
        <tr>
          <td colspan='2' align='center'>
            <textarea name="comments" cols="90" rows="15" style='font-size:10 pt'><%Response.Write(  comments) %></textarea>
          </td>
        </tr>
        <tr>
        </tr>
        <tr>
        </tr>
        <tr>
        </tr>
      </TABLE>

    </FORM>

</body>